//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 17 textures and 305 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/29/1997    (29.08.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <12.333, -5.368, 3.697>
  direction <0.0,     0.0,  5.6905>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.260, 7.616, 1.020>
}

// *******  L I G H T S *******
light_source { // Moonlight
  <-401.838, 395.874, -31.820>
  color  rgb<0.282, 0.282, 0.384>
  area_light <0.548, -0.511, 1.854>, <136.400, 146.271, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // CameraLight
  <12.993, -6.510, 3.827>
  color rgb <0.802, 0.802, 0.802>
  shadowless
}


// ********  TEXTURES  *******
//

#include "genie.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******





#declare Desert_Floor = object { 
  height_field {
    tga "C:\JUNK\POVMORAY\DESERT.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Sand
  }
  no_shadow
  scale <100.0, 100.0, 9.0>
  rotate <15.0, 0.0, 43.0>
  translate  <-225.428541, 377.221758, -76.234778>
}
#declare SlopedLand = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -11.483637, 0.031798>, <-2.000000, -11.483637, 0.031798>, <-1.000000, -11.483637, 0.031798>, <0.000000, -11.483637, 0.031798>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -1.781527, 1.542110>, <-1.000000, -1.781527, 1.542110>, <0.000000, -1.794705, 1.067691>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.321523, 0.654193>, <-1.000000, -1.321523, 0.654193>, <0.000000, -1.334701, 0.179774>, 
      <-3.000000, 0.000000, 0.000000>, <-1.773273, -0.160762, 0.961169>, <-0.886637, -0.160762, 0.644133>, <0.056682, -0.167351, 0.248405>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-1.773273, -0.160762, 0.961169>, <-0.886637, -0.160762, 0.644133>, <0.056682, -0.167351, 0.248405>, 
      <-3.000000, 1.000000, 0.000000>, <-1.546546, 1.000000, 1.268146>, <-0.773273, 1.000000, 0.634073>, <0.113363, 1.000000, 0.317037>, 
      <-3.000000, 2.000000, 0.000000>, <-0.025754, 2.000000, 3.122803>, <0.747519, 2.000000, 2.488730>, <0.873760, 2.000000, 2.443590>, 
      <-3.000000, 4.397708, -0.010436>, <-2.000000, 4.397708, -0.010436>, <-1.000000, 4.397708, -0.010436>, <0.000000, 4.397708, -0.010436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -11.483637, 0.031798>, <1.000000, -11.483637, 0.031798>, <2.000000, -11.483637, 0.031798>, <3.000000, -11.483637, 0.031798>, 
      <0.000000, -1.794705, 1.067691>, <1.000000, -1.807883, 0.593272>, <2.000000, -1.781527, 1.542110>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -1.334701, 0.179774>, <1.000000, -1.347880, -0.294645>, <2.000000, -1.321523, 0.654193>, <3.000000, -1.000000, 0.000000>, 
      <0.056682, -0.167351, 0.248405>, <1.000000, -0.173940, -0.147322>, <2.000000, -0.160762, 0.327096>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.056682, -0.167351, 0.248405>, <1.000000, -0.173940, -0.147322>, <2.000000, -0.160762, 0.327096>, <3.000000, 0.000000, 0.000000>, 
      <0.113363, 1.000000, 0.317037>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.873760, 2.000000, 2.443590>, <1.000000, 2.000000, 2.398450>, <2.000000, 2.000000, 2.398450>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 4.397708, -0.010436>, <1.000000, 4.397708, -0.010436>, <2.000000, 4.397708, -0.010436>, <3.000000, 4.397708, -0.010436>
    }
  }
  texture {
    DuneSand
  }
  scale <30.0, 7.0, 13.0>
  rotate <15.0, 0.0, 43.0>
  translate  <-347.230462, 386.457694, -62.986383>
}
#declare Corner = object { 
  height_field {
    tga "C:\JUNK\POVMORAY\DESERT2.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Sand
  }
  scale <100.0, 100.0, 9.0>
  rotate <15.0, 0.0, 43.0>
  translate  <-361.256582, 249.593235, -76.234>
}
merge { // land
  object { Desert_Floor }
  object { SlopedLand }
  object { Corner }
}


sphere { // Moon
  <0,0,0>,1
  texture {
    MoonSurface
  }
  no_shadow
  scale 4.0
  translate  <-408.054787, 399.812935, -35.211832>
}


//
// Include file contains 'Smoke'
//
#include "genie.in1"
object {   // Smoke
  Smoke_Raw
  texture {
    Smoky
  }
  scale <0.8, 0.8, 0.4>
  rotate <104.295448, 45.15451, 126.150803>
  translate  <-0.309943, 8.242525, 0.736978>
}


#declare Jewel = lathe {
  linear_spline
  4  // control points
  <1.0, -1.0>,
  <2.0, -0.5>,
  <2.0, 0.5>,
  <1.0, 1.0>
  rotate <90,0,90>
  texture {
    Ruby
  }
  scale 0.017
  rotate 45.947777*x
  translate  <0.709193, 9.356054, 2.056896>
}
union { // RingDone
  object { Jewel }
  torus { // Ring
    1.88, 0.12  rotate -x*90
    texture {
      Spun_Gold
    }
    scale 0.045
    rotate <163.332382, -41.958443, -44.237732>
    translate  <0.690625, 9.427069, 1.995565>
  }
  translate  <-0.024484, 0.0, 0.026367>
}


torus { // Bracelet
  1.88, 0.12  rotate -x*90
  texture {
    Spun_Brass1
  }
  scale 0.12
  rotate <87.687263, -56.158916, -74.132179>
  translate  <0.215626, 8.739467, 0.804832>
}


prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  65  // control points
  <-0.712975, -0.295059>,
  <-0.543602, -0.767899>,
  <-0.362515, -0.975781>,
  <-0.260373, -1.229446>,
  <-0.164936, -1.548087>,
  <-0.042678, -1.742765>,
  <0.062559, -2.16964>,
  <-0.028348, -3.739174>,
  <0.422257, -3.722193>,
  <0.557453, -2.16596>,
  <0.637235, -1.865439>,
  <0.759552, -1.609577>,
  <0.801976, -1.29338>,
  <0.83274, -1.055436>,
  <0.966918, -0.952799>,
  <1.154816, -0.796091>,
  <1.250404, -0.595836>,
  <1.57114, -0.091672>,
  <1.392139, -0.287493>,
  <1.215778, -0.326373>,
  <1.114897, -0.398606>,
  <0.958494, -0.578058>,
  <0.763969, -0.665814>,
  <0.737837, -0.551422>,
  <0.909235, -0.101394>,
  <1.021338, 0.252709>,
  <1.018231, 0.369394>,
  <1.106757, 0.702278>,
  <0.948789, 0.423611>,
  <0.862589, 0.372531>,
  <0.800528, 0.176155>,
  <0.695894, -0.091958>,
  <0.618203, -0.328658>,
  <0.516304, -0.380817>,
  <0.427661, -0.294307>,
  <0.366475, 0.116014>,
  <0.334183, 0.408572>,
  <0.274697, 0.63601>,
  <0.179564, 0.739108>,
  <0.114984, 1.078758>,
  <0.135467, 0.698036>,
  <0.113236, 0.547954>,
  <0.121734, 0.124401>,
  <0.176359, -0.359022>,
  <0.080263, -0.42322>,
  <0.004037, -0.358298>,
  <-0.090716, -0.113559>,
  <-0.177395, 0.323835>,
  <-0.264596, 0.475095>,
  <-0.335331, 0.983059>,
  <-0.33877, 0.471736>,
  <-0.364612, 0.30312>,
  <-0.339494, 0.149052>,
  <-0.258126, -0.28378>,
  <-0.226684, -0.456321>,
  <-0.277672, -0.523396>,
  <-0.40295, -0.518856>,
  <-0.562501, -0.288262>,
  <-0.642679, -0.072745>,
  <-0.737751, -0.01574>,
  <-0.875731, 0.228065>,
  <-0.778906, -0.05907>,
  <-0.922985, -0.040764>,
  <-0.712975, -0.295059>,
  <-0.543602, -0.767899>
  rotate -x*90
  texture {
    LeftHand
  }
  scale <0.45, 0.45, 0.1>
  rotate <155.259064, -60.06271, 155.380615>
  translate  <1.00204, 9.354026, 0.995748>
}


#declare Seal = blob {
  threshold 0.6
  component 1.0, 1.01113, <0.0, 1.08861, 0.700422>
  component 1.0, 0.96049, <0.0, 1.35865, 0.092827>
  component 1.0, 0.639888, <0.0, 1.10549, -0.548523>
  component 1.0, 0.613677, <0.0, 0.700422, -0.329114>
  component 1.0, 0.88016, <0.0, 0.109705, 0.852321>
  component 1.0, 0.604339, <0.0, 0.582278, 0.801688>
  component 1.0, 0.608507, <0.0, 0.379747, -0.481013>
  component 1.0, 0.759958, <0.0, -0.075949, -0.092827>
  component 1.0, 0.780468, <0.0, -0.075949, 0.43038>
  component 1.0, 1.03338, <0.0, 0.447257, 0.177215>
  component 1.0, 1.14643, <0.0, 0.320675, -0.675106>
  component 1.0, 1.17689, <0.0, 1.6962, -0.700422>
  component 1.0, 1.27036, <0.0, 1.75527, 1.01266>
  component 1.0, 1.5678, <0.0, 0.033755, 1.35021>
  component 1.0, 0.605383, <0.0, -0.64135, -0.033755>
  scale <0.05, 0.1, 0.1>
  translate  <-0.133163, 8.089627, 0.344003>
}

#declare SealCuts = union {
  box { // Sealcut4
    <-1, -1, -1>, <1, 1, 1>
    rotate 40.216854*x
    translate  <0.0, 0.219345, -1.347403>
  }
  box { // Sealcut3
    <-1, -1, -1>, <1, 1, 1>
    rotate 34.907909*x
    translate  <0.0, 0.06267, -0.908714>
  }
  box { // Sealcut2
    <-1, -1, -1>, <1, 1, 1>
    rotate 40.216854*x
    translate  <0.0, -0.031335, -0.470024>
  }
  box { // Sealcut1
    <-1, -1, -1>, <1, 1, 1>
    rotate 25.432667*x
  }
  box { // Sealcut5
    <-1, -1, -1>, <1, 1, 1>
    rotate 40.216854*x
    translate  <0.0, -0.272727, -1.848938>
  }
  scale 0.1
  translate  <-0.1313, 8.299253, 0.432235>
}
#declare LeftSeal = difference {
  object { Seal }
  object { SealCuts }
  texture {
    Red_Wax
  }
}
difference { // Left_Seal_Done
  object { LeftSeal }
  cylinder { // Stamp
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stampseal
      scale 1.95
  translate <-0.973501, -0.973400, 0.000000>
    }
    scale 0.1
    rotate -90.0*y
    translate  <-0.031808, 8.161045, 0.373126>
  }
  scale 0.5
  rotate -53.0*z
  translate  <-3.518045, 5.574454, 0.503704>
}


plane { // Sky
  z,0
  texture {
    NightSky
  }
  rotate -13.0*x
  translate  75.0*z
}


union { // Carpet
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.999987, -9.263184, 1.086878>, <-3.999990, -9.262168, 1.088931>, <-2.999992, -9.261152, 1.090984>, <-1.999995, -9.260136, 1.093038>, 
      <-5.763985, -7.896926, 0.173074>, <-4.769739, -8.004030, 0.175127>, <-3.775493, -8.111134, 0.177180>, <-2.781248, -8.218238, 0.179233>, 
      <-5.670135, -5.891120, -0.466001>, <-4.675991, -5.999158, -0.463712>, <-3.681846, -6.107197, -0.461422>, <-2.687702, -6.215235, -0.459132>, 
      <-5.335061, -5.273534, 0.240630>, <-4.337990, -5.327053, 0.242805>, <-3.262149, -5.318463, 0.372903>, <-2.304463, -5.403036, 0.311117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.335061, -5.273534, 0.240630>, <-4.337990, -5.327053, 0.242805>, <-3.262149, -5.318463, 0.372903>, <-2.304463, -5.403036, 0.311117>, 
      <-4.999987, -4.655948, 0.947260>, <-3.999990, -4.654947, 0.949321>, <-2.842451, -4.529729, 1.207228>, <-1.921224, -4.590837, 1.081366>, 
      <-4.999987, -3.000000, -0.011454>, <-3.999990, -3.000000, -0.009163>, <-2.842451, -3.000000, 0.277535>, <-1.921224, -3.000000, 0.137622>, 
      <-4.999987, -2.000000, -0.011454>, <-3.999990, -2.000000, -0.009163>, <-2.921222, -2.000000, 0.135331>, <-1.960610, -2.000000, 0.066520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.999987, -2.000000, -0.011454>, <-3.999990, -2.000000, -0.009163>, <-2.921222, -2.000000, 0.135331>, <-1.960610, -2.000000, 0.066520>, 
      <-4.999987, -1.000000, -0.011454>, <-3.999990, -1.000000, -0.009163>, <-2.999992, -1.000000, -0.006872>, <-1.999995, -1.000000, -0.004582>, 
      <-4.999987, 0.000000, -0.011454>, <-3.999990, 0.000000, -0.009163>, <-2.999992, 0.000000, -0.006872>, <-1.999995, 0.000000, -0.004582>, 
      <-4.999987, 1.000000, -0.011454>, <-3.999990, 1.000000, -0.009163>, <-2.999992, 1.000000, -0.006872>, <-2.026497, 1.000000, 0.048647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.999987, 1.000000, -0.011454>, <-3.999990, 1.000000, -0.009163>, <-2.999992, 1.000000, -0.006872>, <-2.026497, 1.000000, 0.048647>, 
      <-4.999987, 2.000000, -0.011454>, <-3.999990, 2.000000, -0.009163>, <-2.999992, 2.000000, -0.006872>, <-2.052998, 2.000000, 0.101875>, 
      <-5.218327, 2.579630, 0.338478>, <-4.221365, 2.657182, 0.345633>, <-3.224402, 2.734735, 0.352787>, <-2.279762, 2.794880, 0.465307>, 
      <-5.296165, 3.394296, 0.581969>, <-4.299203, 3.471120, 0.593835>, <-3.302240, 3.547945, 0.605701>, <-2.331439, 3.616066, 0.670250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.296165, 3.394296, 0.581969>, <-4.299203, 3.471120, 0.593835>, <-3.302240, 3.547945, 0.605701>, <-2.331439, 3.616066, 0.670250>, 
      <-5.374003, 4.208962, 0.825460>, <-4.377041, 4.285058, 0.842038>, <-3.380078, 4.361155, 0.858616>, <-2.383115, 4.437251, 0.875193>, 
      <-5.451841, 5.277305, 0.283528>, <-4.454879, 5.355026, 0.288531>, <-3.457916, 5.432746, 0.293533>, <-2.460953, 5.510467, 0.298535>, 
      <-5.529679, 6.083018, 0.933318>, <-4.532717, 6.159599, 0.947492>, <-3.535754, 6.236180, 0.961666>, <-2.538791, 6.106428, 1.053913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.999995, -9.260136, 1.093038>, <-0.999997, -9.259120, 1.095091>, <0.000000, -9.258105, 1.097144>, <0.999997, -9.257089, 1.099197>, 
      <-2.781248, -8.218238, 0.179233>, <-1.787002, -8.325342, 0.181287>, <-0.792756, -8.432445, 0.183340>, <0.201489, -8.539549, 0.185393>, 
      <-2.687702, -6.215235, -0.459132>, <-1.693558, -6.323274, -0.456843>, <-0.699414, -6.431313, -0.454553>, <0.294730, -6.539351, -0.452264>, 
      <-2.304463, -5.403036, 0.311117>, <-1.346778, -5.487610, 0.249330>, <-0.349707, -5.541129, 0.251505>, <0.647364, -5.594648, 0.253680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.304463, -5.403036, 0.311117>, <-1.346778, -5.487610, 0.249330>, <-0.349707, -5.541129, 0.251505>, <0.647364, -5.594648, 0.253680>, 
      <-1.921224, -4.590837, 1.081366>, <-0.999997, -4.651945, 0.955503>, <0.000000, -4.650945, 0.957564>, <0.999997, -4.649944, 0.959625>, 
      <-1.921224, -3.000000, 0.137622>, <-0.999997, -3.000000, -0.002291>, <0.000000, -3.000000, 0.000000>, <0.999997, -3.000000, 0.002291>, 
      <-1.960610, -2.000000, 0.066520>, <-0.999997, -2.000000, -0.002291>, <-0.034917, -2.000000, 0.077529>, <0.949769, -2.000000, 0.201465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.960610, -2.000000, 0.066520>, <-0.999997, -2.000000, -0.002291>, <-0.034917, -2.000000, 0.077529>, <0.949769, -2.000000, 0.201465>, 
      <-1.999995, -1.000000, -0.004582>, <-0.999997, -1.000000, -0.002291>, <-0.069834, -1.000000, 0.155058>, <0.899542, -1.000000, 0.400639>, 
      <-1.999995, 0.000000, -0.004582>, <-0.999997, 0.000000, -0.002291>, <0.000000, 0.000000, 0.000000>, <0.999997, 0.000000, 0.002291>, 
      <-2.026497, 1.000000, 0.048647>, <-1.053001, 1.000000, 0.104166>, <-0.259642, 0.605263, 0.445953>, <0.767949, 0.605263, 0.418934>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.026497, 1.000000, 0.048647>, <-1.053001, 1.000000, 0.104166>, <-0.259642, 0.605263, 0.445953>, <0.767949, 0.605263, 0.418934>, 
      <-2.052998, 2.000000, 0.101875>, <-1.106005, 2.000000, 0.210623>, <-0.519284, 1.210526, 0.891906>, <0.535901, 1.210526, 0.835576>, 
      <-2.279762, 2.794880, 0.465307>, <-1.335122, 2.855026, 0.577827>, <-0.342980, 2.944174, 0.490036>, <0.708716, 3.033334, 0.439298>, 
      <-2.331439, 3.616066, 0.670250>, <-1.360637, 3.684187, 0.734799>, <-0.366085, 3.766809, 0.699192>, <0.658244, 3.871314, 0.502050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.331439, 3.616066, 0.670250>, <-1.360637, 3.684187, 0.734799>, <-0.366085, 3.766809, 0.699192>, <0.658244, 3.871314, 0.502050>, 
      <-2.383115, 4.437251, 0.875193>, <-1.386153, 4.513348, 0.891771>, <-0.389190, 4.589445, 0.908349>, <0.607772, 4.709293, 0.564803>, 
      <-2.460953, 5.510467, 0.298535>, <-1.463991, 5.588187, 0.303537>, <-0.467028, 5.665908, 0.308539>, <0.529934, 5.771619, 0.856333>, 
      <-2.538791, 6.106428, 1.053913>, <-1.541829, 5.976677, 1.146160>, <-0.544866, 6.053258, 1.160334>, <0.452096, 6.129838, 1.174508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.999997, -9.257089, 1.099197>, <1.999995, -9.256073, 1.101251>, <2.999992, -9.255057, 1.103304>, <3.999990, -9.254041, 1.105357>, 
      <0.201489, -8.539549, 0.185393>, <1.195735, -8.646653, 0.187446>, <2.189981, -8.753757, 0.189500>, <3.184227, -8.860861, 0.191553>, 
      <0.294730, -6.539351, -0.452264>, <1.288874, -6.647390, -0.449974>, <2.283018, -6.755428, -0.447685>, <3.336283, -6.319835, 0.002017>, 
      <0.647364, -5.594648, 0.253680>, <1.644434, -5.648167, 0.255856>, <2.641505, -5.701686, 0.258031>, <3.668136, -5.483389, 0.483912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.647364, -5.594648, 0.253680>, <1.644434, -5.648167, 0.255856>, <2.641505, -5.701686, 0.258031>, <3.668136, -5.483389, 0.483912>, 
      <0.999997, -4.649944, 0.959625>, <1.999995, -4.648944, 0.961685>, <2.999992, -4.647943, 0.963746>, <3.999990, -4.646943, 0.965807>, 
      <0.999997, -3.000000, 0.002291>, <1.999995, -3.000000, 0.004582>, <2.999992, -3.000000, 0.006872>, <3.999990, -3.000000, 0.009163>, 
      <0.949769, -2.000000, 0.201465>, <1.934456, -2.000000, 0.325401>, <2.919143, -2.000000, 0.449338>, <3.903829, -2.000000, 0.573274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.949769, -2.000000, 0.201465>, <1.934456, -2.000000, 0.325401>, <2.919143, -2.000000, 0.449338>, <3.903829, -2.000000, 0.573274>, 
      <0.899542, -1.000000, 0.400639>, <1.868917, -1.000000, 0.646221>, <2.838293, -1.000000, 0.891803>, <3.807669, -1.000000, 1.137385>, 
      <0.999997, 0.000000, 0.002291>, <1.999995, 0.000000, 0.004582>, <2.999992, 0.000000, 0.006872>, <3.999990, 0.000000, 0.009163>, 
      <0.767949, 0.605263, 0.418934>, <1.795540, 0.605263, 0.391914>, <2.795537, 0.605263, 0.394205>, <3.795535, 0.605263, 0.396496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.767949, 0.605263, 0.418934>, <1.795540, 0.605263, 0.391914>, <2.795537, 0.605263, 0.394205>, <3.795535, 0.605263, 0.396496>, 
      <0.535901, 1.210526, 0.835576>, <1.591085, 1.210526, 0.779247>, <2.591083, 1.210526, 0.781537>, <3.591080, 1.210526, 0.783828>, 
      <0.708716, 3.033334, 0.439298>, <1.760411, 3.122495, 0.388560>, <2.757374, 3.200047, 0.395714>, <3.754336, 3.277599, 0.402869>, 
      <0.658244, 3.871314, 0.502050>, <1.682573, 3.975818, 0.304909>, <2.679536, 4.053454, 0.310987>, <3.676498, 4.131091, 0.317065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.658244, 3.871314, 0.502050>, <1.682573, 3.975818, 0.304909>, <2.679536, 4.053454, 0.310987>, <3.676498, 4.131091, 0.317065>, 
      <0.607772, 4.709293, 0.564803>, <1.604735, 4.829141, 0.221258>, <2.601698, 4.906862, 0.226260>, <3.598660, 4.984582, 0.231262>, 
      <0.529934, 5.771619, 0.856333>, <1.526897, 5.877330, 1.404126>, <2.523860, 5.955051, 1.409128>, <3.520822, 6.032771, 1.414130>, 
      <0.452096, 6.129838, 1.174508>, <1.449059, 6.206419, 1.188682>, <2.446022, 6.283000, 1.202856>, <3.442984, 6.359580, 1.217030>
    }
  }
  texture {
    Carpet_Text
    scale <9.0, 15.6, 1.0>
  translate <-5.292107, -9.277868, 0.113056>
  }
  no_shadow
  scale 0.7
  translate  <-0.747892, 7.561972, 0.0>
}


//
// Include file contains 'CorkBot'
//
#include "genie.in2"
#declare CorkBot = object {
  CorkBot_Raw
  texture {
    BlueWax
  }
  scale 0.18
  translate  <-0.898319, 9.99261, 1.593462>
}
#declare Seal1 = blob {
  threshold 0.6
  component 1.0, 1.01113, <0.0, 1.08861, 0.700422>
  component 1.0, 0.96049, <0.0, 1.35865, 0.092827>
  component 1.0, 0.639888, <0.0, 1.10549, -0.548523>
  component 1.0, 0.613677, <0.0, 0.700422, -0.329114>
  component 1.0, 0.88016, <0.0, 0.109705, 0.852321>
  component 1.0, 0.604339, <0.0, 0.582278, 0.801688>
  component 1.0, 0.608507, <0.0, 0.379747, -0.481013>
  component 1.0, 0.759958, <0.0, -0.075949, -0.092827>
  component 1.0, 0.780468, <0.0, -0.075949, 0.43038>
  component 1.0, 1.03338, <0.0, 0.447257, 0.177215>
  component 1.0, 1.14643, <0.0, 0.320675, -0.675106>
  component 1.0, 1.17689, <0.0, 1.6962, -0.700422>
  component 1.0, 1.27036, <0.0, 1.75527, 1.01266>
  component 1.0, 1.5678, <0.0, 0.033755, 1.35021>
  component 1.0, 0.605383, <0.0, -0.64135, -0.033755>
  scale <0.05, 0.1, 0.1>
  translate  <-0.133163, 8.089627, 0.344003>
}

#declare SealCuts1 = union {
  box { // Sealcut6
    <-1, -1, -1>, <1, 1, 1>
    rotate 40.216854*x
    translate  <0.0, 0.219345, -1.347403>
  }
  box { // Sealcut7
    <-1, -1, -1>, <1, 1, 1>
    rotate 34.907909*x
    translate  <0.0, 0.06267, -0.908714>
  }
  box { // Sealcut8
    <-1, -1, -1>, <1, 1, 1>
    rotate 40.216854*x
    translate  <0.0, -0.031335, -0.470024>
  }
  box { // Sealcut9
    <-1, -1, -1>, <1, 1, 1>
    rotate 25.432667*x
  }
  box { // Sealcut10
    <-1, -1, -1>, <1, 1, 1>
    rotate 40.216854*x
    translate  <0.0, -0.272727, -1.848938>
  }
  scale 0.1
  translate  <-0.1313, 8.299253, 0.432235>
}
#declare RightSeal = intersection {
  object { Seal1 }
  object { SealCuts1 }
  texture {
    Red_Wax
  }
}
#declare Right_Seal_Done = difference {
  object { RightSeal }
  cylinder { // Stamp1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stampseal
      scale 1.95
  translate <-0.973501, -0.973400, 0.000000>
    }
    scale 0.1
    rotate -90.0*y
    translate  <-0.031808, 8.161045, 0.373126>
  }
  scale 0.5
  rotate 90.0*x
  translate  <-0.729906, 10.175372, -2.489488>
}
union { // Cork_done
  object { CorkBot }
  cone { // CorkBit
    <0,0,0>, 0.6, <0,0,1>, 1.0
    texture {
      Cork
    }
    scale <0.065, 0.065, 0.2>
    translate  <-0.89762, 9.995248, 1.405348>
  }
  object { Right_Seal_Done }
  rotate <32.686249, -10.558331, -75.0>
  translate  <-6.432129, 3.579231, -6.164556>
}


//
// Include file contains 'Genie_Bottle'
//
#include "genie.in3"
#declare Genie_Bottle = object {
  Genie_Bottle_Raw
  texture {
    BlueWax
  }
}
//
// Include file contains 'Genie_Bottle2'
//
#include "genie.in4"
#declare Genie_Bottle2 = object {
  Genie_Bottle2_Raw
  texture {
    Filigree
  }
  scale 1.01
}
#declare twine = union {
  cylinder { // Helix1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    translate  <-0.110157, 0.0, 0.342366>
  }
  cylinder { // Helix2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -9.0*z
    translate  <-0.108801, 0.017232, 0.344866>
  }
  cylinder { // Helix3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -18.0*z
    translate  <-0.104766, 0.03404, 0.347366>
  }
  cylinder { // Helix4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -27.0*z
    translate  <-0.098151, 0.05001, 0.349866>
  }
  cylinder { // Helix5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -36.0*z
    translate  <-0.089119, 0.064749, 0.352366>
  }
  cylinder { // Helix6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -45.0*z
    translate  <-0.077893, 0.077893, 0.354866>
  }
  cylinder { // Helix7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -54.0*z
    translate  <-0.064749, 0.089119, 0.357366>
  }
  cylinder { // Helix8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -63.0*z
    translate  <-0.05001, 0.098151, 0.359866>
  }
  cylinder { // Helix9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -72.0*z
    translate  <-0.03404, 0.104766, 0.362366>
  }
  cylinder { // Helix10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -81.0*z
    translate  <-0.017232, 0.108801, 0.364866>
  }
  cylinder { // Helix11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -90.0*z
    translate  <0.0, 0.110157, 0.367366>
  }
  cylinder { // Helix12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -99.0*z
    translate  <0.017232, 0.108801, 0.369866>
  }
  cylinder { // Helix13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -108.0*z
    translate  <0.03404, 0.104766, 0.372366>
  }
  cylinder { // Helix14
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -117.0*z
    translate  <0.05001, 0.098151, 0.374866>
  }
  cylinder { // Helix15
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -126.0*z
    translate  <0.064749, 0.089119, 0.377366>
  }
  cylinder { // Helix16
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -135.0*z
    translate  <0.077893, 0.077893, 0.379866>
  }
  cylinder { // Helix17
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -144.0*z
    translate  <0.089119, 0.064749, 0.382366>
  }
  cylinder { // Helix18
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -153.0*z
    translate  <0.098151, 0.05001, 0.384866>
  }
  cylinder { // Helix19
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -162.0*z
    translate  <0.104766, 0.03404, 0.387366>
  }
  cylinder { // Helix20
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -171.0*z
    translate  <0.108801, 0.017232, 0.389866>
  }
  cylinder { // Helix21
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -180.0*z
    translate  <0.110157, 0.0, 0.392366>
  }
  cylinder { // Helix22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -189.0*z
    translate  <0.108801, -0.017232, 0.394866>
  }
  cylinder { // Helix23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -198.0*z
    translate  <0.104766, -0.03404, 0.397366>
  }
  cylinder { // Helix24
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -207.0*z
    translate  <0.098151, -0.05001, 0.399866>
  }
  cylinder { // Helix25
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -216.0*z
    translate  <0.089119, -0.064749, 0.402366>
  }
  cylinder { // Helix26
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -225.0*z
    translate  <0.077893, -0.077893, 0.404866>
  }
  cylinder { // Helix27
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -234.0*z
    translate  <0.064749, -0.089119, 0.407366>
  }
  cylinder { // Helix28
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -243.0*z
    translate  <0.05001, -0.098151, 0.409866>
  }
  cylinder { // Helix29
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -252.0*z
    translate  <0.03404, -0.104766, 0.412366>
  }
  cylinder { // Helix30
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -261.0*z
    translate  <0.017232, -0.108801, 0.414866>
  }
  cylinder { // Helix31
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -270.0*z
    translate  <0.0, -0.110157, 0.417366>
  }
  cylinder { // Helix32
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -279.0*z
    translate  <-0.017232, -0.108801, 0.419866>
  }
  cylinder { // Helix33
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -288.0*z
    translate  <-0.03404, -0.104766, 0.422366>
  }
  cylinder { // Helix34
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -297.0*z
    translate  <-0.05001, -0.098151, 0.424866>
  }
  cylinder { // Helix35
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -306.0*z
    translate  <-0.064749, -0.089119, 0.427366>
  }
  cylinder { // Helix36
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -315.0*z
    translate  <-0.077893, -0.077893, 0.429866>
  }
  cylinder { // Helix37
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -324.0*z
    translate  <-0.089119, -0.064749, 0.432366>
  }
  cylinder { // Helix38
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -333.0*z
    translate  <-0.098151, -0.05001, 0.434866>
  }
  cylinder { // Helix39
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -342.0*z
    translate  <-0.104766, -0.03404, 0.437366>
  }
  cylinder { // Helix40
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -351.0*z
    translate  <-0.108801, -0.017232, 0.439866>
  }
  cylinder { // Helix41
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -360.0*z
    translate  <-0.110157, 0.0, 0.442366>
  }
  cylinder { // Helix42
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -369.0*z
    translate  <-0.108801, 0.017232, 0.444866>
  }
  cylinder { // Helix43
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -378.0*z
    translate  <-0.104766, 0.03404, 0.447366>
  }
  cylinder { // Helix44
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -387.0*z
    translate  <-0.098151, 0.05001, 0.449866>
  }
  cylinder { // Helix45
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -396.0*z
    translate  <-0.089119, 0.064749, 0.452366>
  }
  cylinder { // Helix46
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -405.0*z
    translate  <-0.077893, 0.077893, 0.454866>
  }
  cylinder { // Helix47
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -414.0*z
    translate  <-0.064749, 0.089119, 0.457366>
  }
  cylinder { // Helix48
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -423.0*z
    translate  <-0.05001, 0.098151, 0.459866>
  }
  cylinder { // Helix49
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -432.0*z
    translate  <-0.03404, 0.104766, 0.462366>
  }
  cylinder { // Helix50
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -441.0*z
    translate  <-0.017232, 0.108801, 0.464866>
  }
  cylinder { // Helix51
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -450.0*z
    translate  <0.0, 0.110157, 0.467366>
  }
  cylinder { // Helix52
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -459.0*z
    translate  <0.017232, 0.108801, 0.469866>
  }
  cylinder { // Helix53
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -468.0*z
    translate  <0.03404, 0.104766, 0.472366>
  }
  cylinder { // Helix54
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -477.0*z
    translate  <0.05001, 0.098151, 0.474866>
  }
  cylinder { // Helix55
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -486.0*z
    translate  <0.064749, 0.089119, 0.477366>
  }
  cylinder { // Helix56
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -495.0*z
    translate  <0.077893, 0.077893, 0.479866>
  }
  cylinder { // Helix57
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -504.0*z
    translate  <0.089119, 0.064749, 0.482366>
  }
  cylinder { // Helix58
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -513.0*z
    translate  <0.098151, 0.05001, 0.484866>
  }
  cylinder { // Helix59
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -522.0*z
    translate  <0.104766, 0.03404, 0.487366>
  }
  cylinder { // Helix60
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -531.0*z
    translate  <0.108801, 0.017232, 0.489866>
  }
  cylinder { // Helix61
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -540.0*z
    translate  <0.110157, 0.0, 0.492366>
  }
  cylinder { // Helix62
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -549.0*z
    translate  <0.108801, -0.017232, 0.494866>
  }
  cylinder { // Helix63
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -558.0*z
    translate  <0.104766, -0.03404, 0.497366>
  }
  cylinder { // Helix64
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -567.0*z
    translate  <0.098151, -0.05001, 0.499866>
  }
  cylinder { // Helix65
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -576.0*z
    translate  <0.089119, -0.064749, 0.502366>
  }
  cylinder { // Helix66
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -585.0*z
    translate  <0.077893, -0.077893, 0.504866>
  }
  cylinder { // Helix67
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -594.0*z
    translate  <0.064749, -0.089119, 0.507366>
  }
  cylinder { // Helix68
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -603.0*z
    translate  <0.05001, -0.098151, 0.509866>
  }
  cylinder { // Helix69
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -612.0*z
    translate  <0.03404, -0.104766, 0.512366>
  }
  cylinder { // Helix70
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -621.0*z
    translate  <0.017232, -0.108801, 0.514866>
  }
  cylinder { // Helix71
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -630.0*z
    translate  <0.0, -0.110157, 0.517366>
  }
  cylinder { // Helix72
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -639.0*z
    translate  <-0.017232, -0.108801, 0.519866>
  }
  cylinder { // Helix73
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -648.0*z
    translate  <-0.03404, -0.104766, 0.522366>
  }
  cylinder { // Helix74
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -657.0*z
    translate  <-0.05001, -0.098151, 0.524866>
  }
  cylinder { // Helix75
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -666.0*z
    translate  <-0.064749, -0.089119, 0.527366>
  }
  cylinder { // Helix76
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -675.0*z
    translate  <-0.077893, -0.077893, 0.529866>
  }
  cylinder { // Helix77
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -684.0*z
    translate  <-0.089119, -0.064749, 0.532366>
  }
  cylinder { // Helix78
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -693.0*z
    translate  <-0.098151, -0.05001, 0.534866>
  }
  cylinder { // Helix79
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -702.0*z
    translate  <-0.104766, -0.03404, 0.537366>
  }
  cylinder { // Helix80
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -711.0*z
    translate  <-0.108801, -0.017232, 0.539866>
  }
  cylinder { // Helix81
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -720.0*z
    translate  <-0.110157, 0.0, 0.542366>
  }
  cylinder { // Helix82
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -729.0*z
    translate  <-0.108801, 0.017232, 0.544866>
  }
  cylinder { // Helix83
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -738.0*z
    translate  <-0.104766, 0.03404, 0.547366>
  }
  cylinder { // Helix84
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -747.0*z
    translate  <-0.098151, 0.05001, 0.549866>
  }
  cylinder { // Helix85
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -756.0*z
    translate  <-0.089119, 0.064749, 0.552366>
  }
  cylinder { // Helix86
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -765.0*z
    translate  <-0.077893, 0.077893, 0.554866>
  }
  cylinder { // Helix87
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -774.0*z
    translate  <-0.064749, 0.089119, 0.557366>
  }
  cylinder { // Helix88
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -783.0*z
    translate  <-0.05001, 0.098151, 0.559866>
  }
  cylinder { // Helix89
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -792.0*z
    translate  <-0.03404, 0.104766, 0.562366>
  }
  cylinder { // Helix90
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -801.0*z
    translate  <-0.017232, 0.108801, 0.564866>
  }
  cylinder { // Helix91
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -810.0*z
    translate  <0.0, 0.110157, 0.567366>
  }
  cylinder { // Helix92
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -819.0*z
    translate  <0.017232, 0.108801, 0.569866>
  }
  cylinder { // Helix93
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -828.0*z
    translate  <0.03404, 0.104766, 0.572366>
  }
  cylinder { // Helix94
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -837.0*z
    translate  <0.05001, 0.098151, 0.574866>
  }
  cylinder { // Helix95
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -846.0*z
    translate  <0.064749, 0.089119, 0.577366>
  }
  cylinder { // Helix96
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -855.0*z
    translate  <0.077893, 0.077893, 0.579866>
  }
  cylinder { // Helix97
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -864.0*z
    translate  <0.089119, 0.064749, 0.582366>
  }
  cylinder { // Helix98
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -873.0*z
    translate  <0.098151, 0.05001, 0.584866>
  }
  cylinder { // Helix99
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -882.0*z
    translate  <0.104766, 0.03404, 0.587366>
  }
  cylinder { // Helix100
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -891.0*z
    translate  <0.108801, 0.017232, 0.589866>
  }
  cylinder { // Helix101
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -900.0*z
    translate  <0.110157, 0.0, 0.592366>
  }
  cylinder { // Helix102
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -909.0*z
    translate  <0.108801, -0.017232, 0.594866>
  }
  cylinder { // Helix103
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -918.0*z
    translate  <0.104766, -0.03404, 0.597366>
  }
  cylinder { // Helix104
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -927.0*z
    translate  <0.098151, -0.05001, 0.599866>
  }
  cylinder { // Helix105
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -936.0*z
    translate  <0.089119, -0.064749, 0.602366>
  }
  cylinder { // Helix106
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -945.0*z
    translate  <0.077893, -0.077893, 0.604866>
  }
  cylinder { // Helix107
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -954.0*z
    translate  <0.064749, -0.089119, 0.607366>
  }
  cylinder { // Helix108
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -963.0*z
    translate  <0.05001, -0.098151, 0.609866>
  }
  cylinder { // Helix109
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -972.0*z
    translate  <0.03404, -0.104766, 0.612366>
  }
  cylinder { // Helix110
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -981.0*z
    translate  <0.017232, -0.108801, 0.614866>
  }
  cylinder { // Helix111
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -990.0*z
    translate  <0.0, -0.110157, 0.617366>
  }
  cylinder { // Helix112
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -999.0*z
    translate  <-0.017232, -0.108801, 0.619866>
  }
  cylinder { // Helix113
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1008.0*z
    translate  <-0.03404, -0.104766, 0.622366>
  }
  cylinder { // Helix114
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1017.0*z
    translate  <-0.05001, -0.098151, 0.624866>
  }
  cylinder { // Helix115
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1026.0*z
    translate  <-0.064749, -0.089119, 0.627366>
  }
  cylinder { // Helix116
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1035.0*z
    translate  <-0.077893, -0.077893, 0.629866>
  }
  cylinder { // Helix117
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1044.0*z
    translate  <-0.089119, -0.064749, 0.632366>
  }
  cylinder { // Helix118
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1053.0*z
    translate  <-0.098151, -0.05001, 0.634866>
  }
  cylinder { // Helix119
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1062.0*z
    translate  <-0.104766, -0.03404, 0.637366>
  }
  cylinder { // Helix120
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1071.0*z
    translate  <-0.108801, -0.017232, 0.639866>
  }
  cylinder { // Helix121
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1080.0*z
    translate  <-0.110157, 0.0, 0.642366>
  }
  cylinder { // Helix122
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1089.0*z
    translate  <-0.108801, 0.017232, 0.644866>
  }
  cylinder { // Helix123
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1098.0*z
    translate  <-0.104766, 0.03404, 0.647366>
  }
  cylinder { // Helix124
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1107.0*z
    translate  <-0.098151, 0.05001, 0.649866>
  }
  cylinder { // Helix125
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1116.0*z
    translate  <-0.089119, 0.064749, 0.652366>
  }
  cylinder { // Helix126
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1125.0*z
    translate  <-0.077893, 0.077893, 0.654866>
  }
  cylinder { // Helix127
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1134.0*z
    translate  <-0.064749, 0.089119, 0.657366>
  }
  cylinder { // Helix128
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1143.0*z
    translate  <-0.05001, 0.098151, 0.659866>
  }
  cylinder { // Helix129
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1152.0*z
    translate  <-0.03404, 0.104766, 0.662366>
  }
  cylinder { // Helix130
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1161.0*z
    translate  <-0.017232, 0.108801, 0.664866>
  }
  cylinder { // Helix131
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1170.0*z
    translate  <0.0, 0.110157, 0.667366>
  }
  cylinder { // Helix132
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1179.0*z
    translate  <0.017232, 0.108801, 0.669866>
  }
  cylinder { // Helix133
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1188.0*z
    translate  <0.03404, 0.104766, 0.672366>
  }
  cylinder { // Helix134
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1197.0*z
    translate  <0.05001, 0.098151, 0.674866>
  }
  cylinder { // Helix135
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1206.0*z
    translate  <0.064749, 0.089119, 0.677366>
  }
  cylinder { // Helix136
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1215.0*z
    translate  <0.077893, 0.077893, 0.679866>
  }
  cylinder { // Helix137
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1224.0*z
    translate  <0.089119, 0.064749, 0.682366>
  }
  cylinder { // Helix138
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1233.0*z
    translate  <0.098151, 0.05001, 0.684866>
  }
  cylinder { // Helix139
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1242.0*z
    translate  <0.104766, 0.03404, 0.687366>
  }
  cylinder { // Helix140
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1251.0*z
    translate  <0.108801, 0.017232, 0.689866>
  }
  cylinder { // Helix141
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1260.0*z
    translate  <0.110157, 0.0, 0.692366>
  }
  cylinder { // Helix142
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1269.0*z
    translate  <0.108801, -0.017232, 0.694866>
  }
  cylinder { // Helix143
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1278.0*z
    translate  <0.104766, -0.03404, 0.697366>
  }
  cylinder { // Helix144
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1287.0*z
    translate  <0.098151, -0.05001, 0.699866>
  }
  cylinder { // Helix145
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1296.0*z
    translate  <0.089119, -0.064749, 0.702366>
  }
  cylinder { // Helix146
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1305.0*z
    translate  <0.077893, -0.077893, 0.704866>
  }
  cylinder { // Helix147
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1314.0*z
    translate  <0.064749, -0.089119, 0.707366>
  }
  cylinder { // Helix148
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1323.0*z
    translate  <0.05001, -0.098151, 0.709866>
  }
  cylinder { // Helix149
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1332.0*z
    translate  <0.03404, -0.104766, 0.712366>
  }
  cylinder { // Helix150
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1341.0*z
    translate  <0.017232, -0.108801, 0.714866>
  }
  cylinder { // Helix151
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1350.0*z
    translate  <0.0, -0.110157, 0.717366>
  }
  cylinder { // Helix152
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1359.0*z
    translate  <-0.017232, -0.108801, 0.719866>
  }
  cylinder { // Helix153
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1368.0*z
    translate  <-0.03404, -0.104766, 0.722366>
  }
  cylinder { // Helix154
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1377.0*z
    translate  <-0.05001, -0.098151, 0.724866>
  }
  cylinder { // Helix155
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1386.0*z
    translate  <-0.064749, -0.089119, 0.727366>
  }
  cylinder { // Helix156
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1395.0*z
    translate  <-0.077893, -0.077893, 0.729866>
  }
  cylinder { // Helix157
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1404.0*z
    translate  <-0.089119, -0.064749, 0.732366>
  }
  cylinder { // Helix158
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1413.0*z
    translate  <-0.098151, -0.05001, 0.734866>
  }
  cylinder { // Helix159
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1422.0*z
    translate  <-0.104766, -0.03404, 0.737366>
  }
  cylinder { // Helix160
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1431.0*z
    translate  <-0.108801, -0.017232, 0.739866>
  }
  cylinder { // Helix161
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1440.0*z
    translate  <-0.110157, 0.0, 0.742366>
  }
  cylinder { // Helix162
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1449.0*z
    translate  <-0.108801, 0.017232, 0.744866>
  }
  cylinder { // Helix163
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1458.0*z
    translate  <-0.104766, 0.03404, 0.747366>
  }
  cylinder { // Helix164
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1467.0*z
    translate  <-0.098151, 0.05001, 0.749866>
  }
  cylinder { // Helix165
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1476.0*z
    translate  <-0.089119, 0.064749, 0.752366>
  }
  cylinder { // Helix166
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1485.0*z
    translate  <-0.077893, 0.077893, 0.754866>
  }
  cylinder { // Helix167
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1494.0*z
    translate  <-0.064749, 0.089119, 0.757366>
  }
  cylinder { // Helix168
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1503.0*z
    translate  <-0.05001, 0.098151, 0.759866>
  }
  cylinder { // Helix169
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1512.0*z
    translate  <-0.03404, 0.104766, 0.762366>
  }
  cylinder { // Helix170
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1521.0*z
    translate  <-0.017232, 0.108801, 0.764866>
  }
  cylinder { // Helix171
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1530.0*z
    translate  <0.0, 0.110157, 0.767366>
  }
  cylinder { // Helix172
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1539.0*z
    translate  <0.017232, 0.108801, 0.769866>
  }
  cylinder { // Helix173
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1548.0*z
    translate  <0.03404, 0.104766, 0.772366>
  }
  cylinder { // Helix174
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1557.0*z
    translate  <0.05001, 0.098151, 0.774866>
  }
  cylinder { // Helix175
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1566.0*z
    translate  <0.064749, 0.089119, 0.777366>
  }
  cylinder { // Helix176
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1575.0*z
    translate  <0.077893, 0.077893, 0.779866>
  }
  cylinder { // Helix177
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1584.0*z
    translate  <0.089119, 0.064749, 0.782366>
  }
  cylinder { // Helix178
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1593.0*z
    translate  <0.098151, 0.05001, 0.784866>
  }
  cylinder { // Helix179
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1602.0*z
    translate  <0.104766, 0.03404, 0.787366>
  }
  cylinder { // Helix180
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1611.0*z
    translate  <0.108801, 0.017232, 0.789866>
  }
  cylinder { // Helix181
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1620.0*z
    translate  <0.110157, 0.0, 0.792366>
  }
  cylinder { // Helix182
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1629.0*z
    translate  <0.108801, -0.017232, 0.794866>
  }
  cylinder { // Helix183
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1638.0*z
    translate  <0.104766, -0.03404, 0.797366>
  }
  cylinder { // Helix184
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1647.0*z
    translate  <0.098151, -0.05001, 0.799866>
  }
  cylinder { // Helix185
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1656.0*z
    translate  <0.089119, -0.064749, 0.802366>
  }
  cylinder { // Helix186
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1665.0*z
    translate  <0.077893, -0.077893, 0.804866>
  }
  cylinder { // Helix187
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1674.0*z
    translate  <0.064749, -0.089119, 0.807366>
  }
  cylinder { // Helix188
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1683.0*z
    translate  <0.05001, -0.098151, 0.809866>
  }
  cylinder { // Helix189
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1692.0*z
    translate  <0.03404, -0.104766, 0.812366>
  }
  cylinder { // Helix190
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1701.0*z
    translate  <0.017232, -0.108801, 0.814866>
  }
  cylinder { // Helix191
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1710.0*z
    translate  <0.0, -0.110157, 0.817366>
  }
  cylinder { // Helix192
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1719.0*z
    translate  <-0.017232, -0.108801, 0.819866>
  }
  cylinder { // Helix193
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1728.0*z
    translate  <-0.03404, -0.104766, 0.822366>
  }
  cylinder { // Helix194
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1737.0*z
    translate  <-0.05001, -0.098151, 0.824866>
  }
  cylinder { // Helix195
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1746.0*z
    translate  <-0.064749, -0.089119, 0.827366>
  }
  cylinder { // Helix196
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1755.0*z
    translate  <-0.077893, -0.077893, 0.829866>
  }
  cylinder { // Helix197
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1764.0*z
    translate  <-0.089119, -0.064749, 0.832366>
  }
  cylinder { // Helix198
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1773.0*z
    translate  <-0.098151, -0.05001, 0.834866>
  }
  cylinder { // Helix199
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1782.0*z
    translate  <-0.104766, -0.03404, 0.837366>
  }
  cylinder { // Helix200
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1791.0*z
    translate  <-0.108801, -0.017232, 0.839866>
  }
  cylinder { // Helix201
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1800.0*z
    translate  <-0.110157, 0.0, 0.842366>
  }
  cylinder { // Helix202
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1809.0*z
    translate  <-0.108801, 0.017232, 0.844866>
  }
  cylinder { // Helix203
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1818.0*z
    translate  <-0.104766, 0.03404, 0.847366>
  }
  cylinder { // Helix204
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1827.0*z
    translate  <-0.098151, 0.05001, 0.849866>
  }
  cylinder { // Helix205
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1836.0*z
    translate  <-0.089119, 0.064749, 0.852366>
  }
  cylinder { // Helix206
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1845.0*z
    translate  <-0.077893, 0.077893, 0.854866>
  }
  cylinder { // Helix207
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1854.0*z
    translate  <-0.064749, 0.089119, 0.857366>
  }
  cylinder { // Helix208
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1863.0*z
    translate  <-0.05001, 0.098151, 0.859866>
  }
  cylinder { // Helix209
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1872.0*z
    translate  <-0.03404, 0.104766, 0.862366>
  }
  cylinder { // Helix210
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1881.0*z
    translate  <-0.017232, 0.108801, 0.864866>
  }
  cylinder { // Helix211
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1890.0*z
    translate  <0.0, 0.110157, 0.867366>
  }
  cylinder { // Helix212
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1899.0*z
    translate  <0.017232, 0.108801, 0.869866>
  }
  cylinder { // Helix213
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1908.0*z
    translate  <0.03404, 0.104766, 0.872366>
  }
  cylinder { // Helix214
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1917.0*z
    translate  <0.05001, 0.098151, 0.874866>
  }
  cylinder { // Helix215
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1926.0*z
    translate  <0.064749, 0.089119, 0.877366>
  }
  cylinder { // Helix216
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1935.0*z
    translate  <0.077893, 0.077893, 0.879866>
  }
  cylinder { // Helix217
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1944.0*z
    translate  <0.089119, 0.064749, 0.882366>
  }
  cylinder { // Helix218
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1953.0*z
    translate  <0.098151, 0.05001, 0.884866>
  }
  cylinder { // Helix219
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1962.0*z
    translate  <0.104766, 0.03404, 0.887366>
  }
  cylinder { // Helix220
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1971.0*z
    translate  <0.108801, 0.017232, 0.889866>
  }
  cylinder { // Helix221
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1980.0*z
    translate  <0.110157, 0.0, 0.892366>
  }
  cylinder { // Helix222
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1989.0*z
    translate  <0.108801, -0.017232, 0.894866>
  }
  cylinder { // Helix223
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -1998.0*z
    translate  <0.104766, -0.03404, 0.897366>
  }
  cylinder { // Helix224
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2007.0*z
    translate  <0.098151, -0.05001, 0.899866>
  }
  cylinder { // Helix225
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2016.0*z
    translate  <0.089119, -0.064749, 0.902366>
  }
  cylinder { // Helix226
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2025.0*z
    translate  <0.077893, -0.077893, 0.904866>
  }
  cylinder { // Helix227
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2034.0*z
    translate  <0.064749, -0.089119, 0.907366>
  }
  cylinder { // Helix228
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2043.0*z
    translate  <0.05001, -0.098151, 0.909866>
  }
  cylinder { // Helix229
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2052.0*z
    translate  <0.03404, -0.104766, 0.912366>
  }
  cylinder { // Helix230
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2061.0*z
    translate  <0.017232, -0.108801, 0.914866>
  }
  cylinder { // Helix231
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2070.0*z
    translate  <0.0, -0.110157, 0.917366>
  }
  cylinder { // Helix232
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2079.0*z
    translate  <-0.017232, -0.108801, 0.919866>
  }
  cylinder { // Helix233
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2088.0*z
    translate  <-0.03404, -0.104766, 0.922366>
  }
  cylinder { // Helix234
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2097.0*z
    translate  <-0.05001, -0.098151, 0.924866>
  }
  cylinder { // Helix235
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2106.0*z
    translate  <-0.064749, -0.089119, 0.927366>
  }
  cylinder { // Helix236
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2115.0*z
    translate  <-0.077893, -0.077893, 0.929866>
  }
  cylinder { // Helix237
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2124.0*z
    translate  <-0.089119, -0.064749, 0.932366>
  }
  cylinder { // Helix238
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2133.0*z
    translate  <-0.098151, -0.05001, 0.934866>
  }
  cylinder { // Helix239
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2142.0*z
    translate  <-0.104766, -0.03404, 0.937366>
  }
  cylinder { // Helix240
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2151.0*z
    translate  <-0.108801, -0.017232, 0.939866>
  }
  cylinder { // Helix241
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2160.0*z
    translate  <-0.110157, 0.0, 0.942366>
  }
  cylinder { // Helix242
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2169.0*z
    translate  <-0.108801, 0.017232, 0.944866>
  }
  cylinder { // Helix243
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2178.0*z
    translate  <-0.104766, 0.03404, 0.947366>
  }
  cylinder { // Helix244
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2187.0*z
    translate  <-0.098151, 0.05001, 0.949866>
  }
  cylinder { // Helix245
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2196.0*z
    translate  <-0.089119, 0.064749, 0.952366>
  }
  cylinder { // Helix246
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2205.0*z
    translate  <-0.077893, 0.077893, 0.954866>
  }
  cylinder { // Helix247
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2214.0*z
    translate  <-0.064749, 0.089119, 0.957366>
  }
  cylinder { // Helix248
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2223.0*z
    translate  <-0.05001, 0.098151, 0.959866>
  }
  cylinder { // Helix249
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2232.0*z
    translate  <-0.03404, 0.104766, 0.962366>
  }
  cylinder { // Helix250
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2241.0*z
    translate  <-0.017232, 0.108801, 0.964866>
  }
  cylinder { // Helix251
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2250.0*z
    translate  <0.0, 0.110157, 0.967366>
  }
  cylinder { // Helix252
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2259.0*z
    translate  <0.017232, 0.108801, 0.969866>
  }
  cylinder { // Helix253
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2268.0*z
    translate  <0.03404, 0.104766, 0.972366>
  }
  cylinder { // Helix254
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2277.0*z
    translate  <0.05001, 0.098151, 0.974866>
  }
  cylinder { // Helix255
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2286.0*z
    translate  <0.064749, 0.089119, 0.977366>
  }
  cylinder { // Helix256
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2295.0*z
    translate  <0.077893, 0.077893, 0.979866>
  }
  cylinder { // Helix257
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2304.0*z
    translate  <0.089119, 0.064749, 0.982366>
  }
  cylinder { // Helix258
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2313.0*z
    translate  <0.098151, 0.05001, 0.984866>
  }
  cylinder { // Helix259
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2322.0*z
    translate  <0.104766, 0.03404, 0.987366>
  }
  cylinder { // Helix260
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2331.0*z
    translate  <0.108801, 0.017232, 0.989866>
  }
  cylinder { // Helix261
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2340.0*z
    translate  <0.110157, 0.0, 0.992366>
  }
  cylinder { // Helix262
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2349.0*z
    translate  <0.108801, -0.017232, 0.994866>
  }
  cylinder { // Helix263
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2358.0*z
    translate  <0.104766, -0.03404, 0.997366>
  }
  cylinder { // Helix264
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2367.0*z
    translate  <0.098151, -0.05001, 0.999866>
  }
  cylinder { // Helix265
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2376.0*z
    translate  <0.089119, -0.064749, 1.002366>
  }
  cylinder { // Helix266
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2385.0*z
    translate  <0.077893, -0.077893, 1.004866>
  }
  cylinder { // Helix267
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2394.0*z
    translate  <0.064749, -0.089119, 1.007366>
  }
  cylinder { // Helix268
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2403.0*z
    translate  <0.05001, -0.098151, 1.009866>
  }
  cylinder { // Helix269
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2412.0*z
    translate  <0.03404, -0.104766, 1.012366>
  }
  cylinder { // Helix270
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2421.0*z
    translate  <0.017232, -0.108801, 1.014866>
  }
  cylinder { // Helix271
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.01, 0.03, 0.01>
    rotate -2430.0*z
    translate  <0.0, -0.110157, 1.017366>
  }
}
union { // GEnie_Bottle
  object { Genie_Bottle }
  object { Genie_Bottle2 }
  torus { // Band1
    1.9, 0.1  rotate -x*90
    texture {
      Shiny_Gold1
    }
    scale <0.06, 0.06, 0.35>
    translate  <-0.000118, -0.000082, 1.056457>
  }
  torus { // Band2
    1.9, 0.1  rotate -x*90
    texture {
      Shiny_Gold1
    }
    scale <0.068, 0.068, 0.35>
    translate  <-0.000118, -0.000082, 0.310319>
  }
  object { twine }
  rotate <82.072334, -54.582794, 123.28849>
  translate  <-1.480241, 7.673378, 0.627163>
}


prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  84  // control points
  <-0.569401, -0.005002>,
  <-0.431628, -0.24131>,
  <-0.291063, -0.427984>,
  <-0.188921, -0.681648>,
  <-0.093484, -1.00029>,
  <0.028773, -1.194968>,
  <0.134011, -1.621843>,
  <-0.004936, -2.210673>,
  <-0.344081, -2.701746>,
  <-0.475821, -3.295693>,
  <-0.236594, -3.938518>,
  <0.484086, -4.503414>,
  <1.246918, -4.482586>,
  <1.946318, -4.090383>,
  <2.199603, -4.044622>,
  <2.501727, -4.163449>,
  <2.699272, -3.890102>,
  <2.41463, -3.717776>,
  <2.094145, -3.620322>,
  <1.771969, -3.804716>,
  <1.354068, -4.042089>,
  <0.710172, -4.037449>,
  <0.24733, -3.607845>,
  <0.069137, -3.256627>,
  <0.199945, -2.82736>,
  <0.466714, -2.353486>,
  <0.628905, -1.618163>,
  <0.708687, -1.317642>,
  <0.831004, -1.06178>,
  <0.873428, -0.622163>,
  <0.873203, -0.475937>,
  <1.040099, -0.41548>,
  <1.23519, -0.335951>,
  <1.430119, -0.229925>,
  <1.59774, -0.024259>,
  <1.754152, 0.078524>,
  <1.593708, 0.042237>,
  <1.365814, -0.010087>,
  <0.965386, -0.206883>,
  <0.83542, -0.118017>,
  <0.79184, 0.012939>,
  <0.959166, 0.539262>,
  <1.092496, 0.882736>,
  <1.075279, 0.994543>,
  <1.140609, 1.322031>,
  <0.986057, 1.058137>,
  <0.907786, 1.034342>,
  <0.850399, 0.816786>,
  <0.745823, 0.548651>,
  <0.668183, 0.311934>,
  <0.55435, 0.208738>,
  <0.499113, 0.25349>,
  <0.437927, 0.663811>,
  <0.405635, 0.956369>,
  <0.413297, 1.103112>,
  <0.320407, 1.186084>,
  <0.258898, 1.52754>,
  <0.239884, 1.205044>,
  <0.174036, 1.095751>,
  <0.193185, 0.672198>,
  <0.24781, 0.188775>,
  <0.151715, 0.124577>,
  <0.075488, 0.189499>,
  <-0.019264, 0.434238>,
  <-0.084641, 0.860981>,
  <-0.181575, 0.957403>,
  <-0.251338, 1.275323>,
  <-0.237653, 0.939448>,
  <-0.273252, 0.838208>,
  <-0.268043, 0.696849>,
  <-0.186674, 0.264017>,
  <-0.155232, 0.091476>,
  <-0.20622, 0.024401>,
  <-0.308544, 0.016867>,
  <-0.483667, 0.23587>,
  <-0.532198, 0.379513>,
  <-0.635018, 0.477996>,
  <-0.78753, 0.712098>,
  <-0.710843, 0.446722>,
  <-0.651874, 0.308684>,
  <-0.749599, 0.409912>,
  <-0.701982, 0.284853>,
  <-0.569401, -0.005002>,
  <-0.431628, -0.24131>
  rotate -x*90
  texture {
    RightHand
  }
  no_shadow
  hollow
  scale <0.45, 0.45, 0.1>
  rotate <127.156784, -13.879529, -176.341599>
  translate  <0.987984, 9.35236, 1.896148>
}


